
                                                    

package io.fabric8.openshift.client.handlers.monitoring.coreos;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.ThanosRulerOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.monitoring.v1.ThanosRuler;
import io.fabric8.openshift.api.model.monitoring.v1.ThanosRulerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ThanosRulerHandler implements ResourceHandler<ThanosRuler, ThanosRulerBuilder> {

  @Override
  public String getKind() {
    return ThanosRuler.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "monitoring.coreos.com/v1";
    }

  @Override
  public ThanosRuler create(OkHttpClient client, Config config, String namespace, ThanosRuler item, boolean dryRun) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public ThanosRuler replace(OkHttpClient client, Config config, String namespace, ThanosRuler item, boolean dryRun) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public ThanosRuler reload(OkHttpClient client, Config config, String namespace, ThanosRuler item) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ThanosRulerBuilder edit(ThanosRuler item) {
    return new ThanosRulerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, ThanosRuler item, boolean dryRun) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ThanosRuler item, Watcher<ThanosRuler> watcher) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ThanosRuler item, String resourceVersion, Watcher<ThanosRuler> watcher) {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ThanosRuler item, ListOptions options, Watcher<ThanosRuler> watcher) {
  return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public ThanosRuler waitUntilReady(OkHttpClient client, Config config, String namespace, ThanosRuler item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ThanosRuler waitUntilCondition(OkHttpClient client, Config config, String namespace, ThanosRuler item, Predicate<ThanosRuler> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ThanosRulerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
