
                                                    

package io.fabric8.openshift.client.handlers.network;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.network.HostSubnetOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class HostSubnetHandler implements ResourceHandler<HostSubnet, HostSubnetBuilder> {

  @Override
  public String getKind() {
    return HostSubnet.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.openshift.io/v1";
    }

  @Override
  public HostSubnet create(OkHttpClient client, Config config, String namespace, HostSubnet item, boolean dryRun) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public HostSubnet replace(OkHttpClient client, Config config, String namespace, HostSubnet item, boolean dryRun) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public HostSubnet reload(OkHttpClient client, Config config, String namespace, HostSubnet item) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public HostSubnetBuilder edit(HostSubnet item) {
    return new HostSubnetBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, HostSubnet item, boolean dryRun) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, Watcher<HostSubnet> watcher) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, String resourceVersion, Watcher<HostSubnet> watcher) {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, HostSubnet item, ListOptions options, Watcher<HostSubnet> watcher) {
  return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public HostSubnet waitUntilReady(OkHttpClient client, Config config, String namespace, HostSubnet item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public HostSubnet waitUntilCondition(OkHttpClient client, Config config, String namespace, HostSubnet item, Predicate<HostSubnet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new HostSubnetOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
