
                                                    

package io.fabric8.openshift.client.handlers.network.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.network.operator.OperatorPKIOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKI;
import io.fabric8.openshift.api.model.miscellaneous.network.operator.v1.OperatorPKIBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OperatorPKIHandler implements ResourceHandler<OperatorPKI, OperatorPKIBuilder> {

  @Override
  public String getKind() {
    return OperatorPKI.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "network.operator.openshift.io/v1";
    }

  @Override
  public OperatorPKI create(OkHttpClient client, Config config, String namespace, OperatorPKI item, boolean dryRun) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OperatorPKI replace(OkHttpClient client, Config config, String namespace, OperatorPKI item, boolean dryRun) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OperatorPKI reload(OkHttpClient client, Config config, String namespace, OperatorPKI item) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OperatorPKIBuilder edit(OperatorPKI item) {
    return new OperatorPKIBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OperatorPKI item, boolean dryRun) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorPKI item, Watcher<OperatorPKI> watcher) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorPKI item, String resourceVersion, Watcher<OperatorPKI> watcher) {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorPKI item, ListOptions options, Watcher<OperatorPKI> watcher) {
  return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OperatorPKI waitUntilReady(OkHttpClient client, Config config, String namespace, OperatorPKI item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OperatorPKI waitUntilCondition(OkHttpClient client, Config config, String namespace, OperatorPKI item, Predicate<OperatorPKI> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorPKIOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
