
                                                    

package io.fabric8.openshift.client.handlers.oauth;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.oauth.UserOAuthAccessTokenOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class UserOAuthAccessTokenHandler implements ResourceHandler<UserOAuthAccessToken, UserOAuthAccessTokenBuilder> {

  @Override
  public String getKind() {
    return UserOAuthAccessToken.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "oauth.openshift.io/v1";
    }

  @Override
  public UserOAuthAccessToken create(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, boolean dryRun) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public UserOAuthAccessToken replace(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, boolean dryRun) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public UserOAuthAccessToken reload(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public UserOAuthAccessTokenBuilder edit(UserOAuthAccessToken item) {
    return new UserOAuthAccessTokenBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, UserOAuthAccessToken item, boolean dryRun) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, Watcher<UserOAuthAccessToken> watcher) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, String resourceVersion, Watcher<UserOAuthAccessToken> watcher) {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, ListOptions options, Watcher<UserOAuthAccessToken> watcher) {
  return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public UserOAuthAccessToken waitUntilReady(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public UserOAuthAccessToken waitUntilCondition(OkHttpClient client, Config config, String namespace, UserOAuthAccessToken item, Predicate<UserOAuthAccessToken> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new UserOAuthAccessTokenOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
