
                                                    

package io.fabric8.openshift.client.handlers.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.operator.CloudCredentialOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.CloudCredential;
import io.fabric8.openshift.api.model.operator.v1.CloudCredentialBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CloudCredentialHandler implements ResourceHandler<CloudCredential, CloudCredentialBuilder> {

  @Override
  public String getKind() {
    return CloudCredential.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public CloudCredential create(OkHttpClient client, Config config, String namespace, CloudCredential item, boolean dryRun) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CloudCredential replace(OkHttpClient client, Config config, String namespace, CloudCredential item, boolean dryRun) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CloudCredential reload(OkHttpClient client, Config config, String namespace, CloudCredential item) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CloudCredentialBuilder edit(CloudCredential item) {
    return new CloudCredentialBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CloudCredential item, boolean dryRun) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, Watcher<CloudCredential> watcher) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, String resourceVersion, Watcher<CloudCredential> watcher) {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CloudCredential item, ListOptions options, Watcher<CloudCredential> watcher) {
  return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public CloudCredential waitUntilReady(OkHttpClient client, Config config, String namespace, CloudCredential item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CloudCredential waitUntilCondition(OkHttpClient client, Config config, String namespace, CloudCredential item, Predicate<CloudCredential> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CloudCredentialOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
