
                                                    

package io.fabric8.openshift.client.handlers.operator;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.operator.ConsoleOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operator.v1.Console;
import io.fabric8.openshift.api.model.operator.v1.ConsoleBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConsoleHandler implements ResourceHandler<Console, ConsoleBuilder> {

  @Override
  public String getKind() {
    return Console.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operator.openshift.io/v1";
    }

  @Override
  public Console create(OkHttpClient client, Config config, String namespace, Console item, boolean dryRun) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Console replace(OkHttpClient client, Config config, String namespace, Console item, boolean dryRun) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Console reload(OkHttpClient client, Config config, String namespace, Console item) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConsoleBuilder edit(Console item) {
    return new ConsoleBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Console item, boolean dryRun) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Console item, Watcher<Console> watcher) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Console item, String resourceVersion, Watcher<Console> watcher) {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Console item, ListOptions options, Watcher<Console> watcher) {
  return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Console waitUntilReady(OkHttpClient client, Config config, String namespace, Console item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Console waitUntilCondition(OkHttpClient client, Config config, String namespace, Console item, Predicate<Console> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConsoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
