
                                                    

package io.fabric8.openshift.client.handlers.operators.coreos;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.operators.coreos.OperatorConditionOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorCondition;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class OperatorConditionHandler implements ResourceHandler<OperatorCondition, OperatorConditionBuilder> {

  @Override
  public String getKind() {
    return OperatorCondition.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "operators.coreos.com/v1";
    }

  @Override
  public OperatorCondition create(OkHttpClient client, Config config, String namespace, OperatorCondition item, boolean dryRun) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public OperatorCondition replace(OkHttpClient client, Config config, String namespace, OperatorCondition item, boolean dryRun) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public OperatorCondition reload(OkHttpClient client, Config config, String namespace, OperatorCondition item) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public OperatorConditionBuilder edit(OperatorCondition item) {
    return new OperatorConditionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, OperatorCondition item, boolean dryRun) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorCondition item, Watcher<OperatorCondition> watcher) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorCondition item, String resourceVersion, Watcher<OperatorCondition> watcher) {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, OperatorCondition item, ListOptions options, Watcher<OperatorCondition> watcher) {
  return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public OperatorCondition waitUntilReady(OkHttpClient client, Config config, String namespace, OperatorCondition item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public OperatorCondition waitUntilCondition(OkHttpClient client, Config config, String namespace, OperatorCondition item, Predicate<OperatorCondition> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new OperatorConditionOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
