
                                                    

package io.fabric8.openshift.client.handlers.packages.operators.coreos;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.packages.operators.coreos.PackageManifestOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifest;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageManifestBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PackageManifestHandler implements ResourceHandler<PackageManifest, PackageManifestBuilder> {

  @Override
  public String getKind() {
    return PackageManifest.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "packages.operators.coreos.com/v1";
    }

  @Override
  public PackageManifest create(OkHttpClient client, Config config, String namespace, PackageManifest item, boolean dryRun) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PackageManifest replace(OkHttpClient client, Config config, String namespace, PackageManifest item, boolean dryRun) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PackageManifest reload(OkHttpClient client, Config config, String namespace, PackageManifest item) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PackageManifestBuilder edit(PackageManifest item) {
    return new PackageManifestBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PackageManifest item, boolean dryRun) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PackageManifest item, Watcher<PackageManifest> watcher) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PackageManifest item, String resourceVersion, Watcher<PackageManifest> watcher) {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PackageManifest item, ListOptions options, Watcher<PackageManifest> watcher) {
  return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public PackageManifest waitUntilReady(OkHttpClient client, Config config, String namespace, PackageManifest item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PackageManifest waitUntilCondition(OkHttpClient client, Config config, String namespace, PackageManifest item, Predicate<PackageManifest> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PackageManifestOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
