
                                                    

package io.fabric8.openshift.client.handlers.template;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.template.BrokerTemplateInstanceOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.BrokerTemplateInstance;
import io.fabric8.openshift.api.model.BrokerTemplateInstanceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class BrokerTemplateInstanceHandler implements ResourceHandler<BrokerTemplateInstance, BrokerTemplateInstanceBuilder> {

  @Override
  public String getKind() {
    return BrokerTemplateInstance.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "template.openshift.io/v1";
    }

  @Override
  public BrokerTemplateInstance create(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, boolean dryRun) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public BrokerTemplateInstance replace(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, boolean dryRun) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public BrokerTemplateInstance reload(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public BrokerTemplateInstanceBuilder edit(BrokerTemplateInstance item) {
    return new BrokerTemplateInstanceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, BrokerTemplateInstance item, boolean dryRun) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, Watcher<BrokerTemplateInstance> watcher) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, String resourceVersion, Watcher<BrokerTemplateInstance> watcher) {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, ListOptions options, Watcher<BrokerTemplateInstance> watcher) {
  return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public BrokerTemplateInstance waitUntilReady(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public BrokerTemplateInstance waitUntilCondition(OkHttpClient client, Config config, String namespace, BrokerTemplateInstance item, Predicate<BrokerTemplateInstance> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerTemplateInstanceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
