
                                                    

package io.fabric8.openshift.client.handlers.tuned;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.tuned.ProfileOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.tuned.v1.Profile;
import io.fabric8.openshift.api.model.tuned.v1.ProfileBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ProfileHandler implements ResourceHandler<Profile, ProfileBuilder> {

  @Override
  public String getKind() {
    return Profile.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "tuned.openshift.io/v1";
    }

  @Override
  public Profile create(OkHttpClient client, Config config, String namespace, Profile item, boolean dryRun) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Profile replace(OkHttpClient client, Config config, String namespace, Profile item, boolean dryRun) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Profile reload(OkHttpClient client, Config config, String namespace, Profile item) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ProfileBuilder edit(Profile item) {
    return new ProfileBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Profile item, boolean dryRun) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, Watcher<Profile> watcher) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, String resourceVersion, Watcher<Profile> watcher) {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Profile item, ListOptions options, Watcher<Profile> watcher) {
  return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Profile waitUntilReady(OkHttpClient client, Config config, String namespace, Profile item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Profile waitUntilCondition(OkHttpClient client, Config config, String namespace, Profile item, Predicate<Profile> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ProfileOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
