
                                                    

package io.fabric8.openshift.client.handlers.tuned;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.openshift.client.dsl.internal.tuned.TunedOperationsImpl;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.openshift.api.model.tuned.v1.Tuned;
import io.fabric8.openshift.api.model.tuned.v1.TunedBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class TunedHandler implements ResourceHandler<Tuned, TunedBuilder> {

  @Override
  public String getKind() {
    return Tuned.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "tuned.openshift.io/v1";
    }

  @Override
  public Tuned create(OkHttpClient client, Config config, String namespace, Tuned item, boolean dryRun) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Tuned replace(OkHttpClient client, Config config, String namespace, Tuned item, boolean dryRun) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Tuned reload(OkHttpClient client, Config config, String namespace, Tuned item) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public TunedBuilder edit(Tuned item) {
    return new TunedBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Tuned item, boolean dryRun) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Tuned item, Watcher<Tuned> watcher) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Tuned item, String resourceVersion, Watcher<Tuned> watcher) {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Tuned item, ListOptions options, Watcher<Tuned> watcher) {
  return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }


  @Override
  public Tuned waitUntilReady(OkHttpClient client, Config config, String namespace, Tuned item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Tuned waitUntilCondition(OkHttpClient client, Config config, String namespace, Tuned item, Predicate<Tuned> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TunedOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
