/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPool;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.IPPoolBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.core.IPPoolOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class IPPoolHandler
implements ResourceHandler<IPPool, IPPoolBuilder> {
    public String getKind() {
        return IPPool.class.getSimpleName();
    }

    public String getApiVersion() {
        return "whereabouts.cni.cncf.io/v1alpha1";
    }

    public IPPool create(OkHttpClient client, Config config, String namespace, IPPool item, boolean dryRun) {
        return (IPPool)((WritableOperation)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new IPPool[0]);
    }

    public IPPool replace(OkHttpClient client, Config config, String namespace, IPPool item, boolean dryRun) {
        return (IPPool)((WritableOperation)((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public IPPool reload(OkHttpClient client, Config config, String namespace, IPPool item) {
        return (IPPool)((Gettable)((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public IPPoolBuilder edit(IPPool item) {
        return new IPPoolBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, IPPool item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, Watcher<IPPool> watcher) {
        return ((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, String resourceVersion, Watcher<IPPool> watcher) {
        return ((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, IPPool item, ListOptions options, Watcher<IPPool> watcher) {
        return ((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public IPPool waitUntilReady(OkHttpClient client, Config config, String namespace, IPPool item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (IPPool)((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public IPPool waitUntilCondition(OkHttpClient client, Config config, String namespace, IPPool item, Predicate<IPPool> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (IPPool)((Resource)new IPPoolOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

