/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigration;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigrationBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.core.StorageVersionMigrationOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class StorageVersionMigrationHandler
implements ResourceHandler<StorageVersionMigration, StorageVersionMigrationBuilder> {
    public String getKind() {
        return StorageVersionMigration.class.getSimpleName();
    }

    public String getApiVersion() {
        return "migration.k8s.io/v1alpha1";
    }

    public StorageVersionMigration create(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, boolean dryRun) {
        return (StorageVersionMigration)((WritableOperation)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new StorageVersionMigration[0]);
    }

    public StorageVersionMigration replace(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, boolean dryRun) {
        return (StorageVersionMigration)((WritableOperation)((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public StorageVersionMigration reload(OkHttpClient client, Config config, String namespace, StorageVersionMigration item) {
        return (StorageVersionMigration)((Gettable)((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public StorageVersionMigrationBuilder edit(StorageVersionMigration item) {
        return new StorageVersionMigrationBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, StorageVersionMigration item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, Watcher<StorageVersionMigration> watcher) {
        return ((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, String resourceVersion, Watcher<StorageVersionMigration> watcher) {
        return ((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, ListOptions options, Watcher<StorageVersionMigration> watcher) {
        return ((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public StorageVersionMigration waitUntilReady(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageVersionMigration)((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public StorageVersionMigration waitUntilCondition(OkHttpClient client, Config config, String namespace, StorageVersionMigration item, Predicate<StorageVersionMigration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StorageVersionMigration)((Resource)new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

