/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.machine;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.machine.v1beta1.Machine;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.machine.MachineOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class MachineHandler
implements ResourceHandler<Machine, MachineBuilder> {
    public String getKind() {
        return Machine.class.getSimpleName();
    }

    public String getApiVersion() {
        return "machine.openshift.io/v1beta1";
    }

    public Machine create(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
        return (Machine)((WritableOperation)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new Machine[0]);
    }

    public Machine replace(OkHttpClient client, Config config, String namespace, Machine item, boolean dryRun) {
        return (Machine)((WritableOperation)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public Machine reload(OkHttpClient client, Config config, String namespace, Machine item) {
        return (Machine)((Gettable)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public MachineBuilder edit(Machine item) {
        return new MachineBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Machine item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, String resourceVersion, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Machine item, ListOptions options, Watcher<Machine> watcher) {
        return ((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public Machine waitUntilReady(OkHttpClient client, Config config, String namespace, Machine item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Machine)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Machine waitUntilCondition(OkHttpClient client, Config config, String namespace, Machine item, Predicate<Machine> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Machine)((Resource)new MachineOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

