/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.handlers.monitoring.coreos;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorBuilder;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.monitoring.coreos.PodMonitorOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class PodMonitorHandler
implements ResourceHandler<PodMonitor, PodMonitorBuilder> {
    public String getKind() {
        return PodMonitor.class.getSimpleName();
    }

    public String getApiVersion() {
        return "monitoring.coreos.com/v1";
    }

    public PodMonitor create(OkHttpClient client, Config config, String namespace, PodMonitor item, boolean dryRun) {
        return (PodMonitor)((WritableOperation)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).dryRun(dryRun)).create((Object[])new PodMonitor[0]);
    }

    public PodMonitor replace(OkHttpClient client, Config config, String namespace, PodMonitor item, boolean dryRun) {
        return (PodMonitor)((WritableOperation)((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace((Object)item);
    }

    public PodMonitor reload(OkHttpClient client, Config config, String namespace, PodMonitor item) {
        return (PodMonitor)((Gettable)((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public PodMonitorBuilder edit(PodMonitor item) {
        return new PodMonitorBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PodMonitor item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, Watcher<PodMonitor> watcher) {
        return ((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, String resourceVersion, Watcher<PodMonitor> watcher) {
        return ((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, PodMonitor item, ListOptions options, Watcher<PodMonitor> watcher) {
        return ((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    public PodMonitor waitUntilReady(OkHttpClient client, Config config, String namespace, PodMonitor item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (PodMonitor)((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public PodMonitor waitUntilCondition(OkHttpClient client, Config config, String namespace, PodMonitor item, Predicate<PodMonitor> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (PodMonitor)((Resource)new PodMonitorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem((HasMetadata)item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

