
                                                    
  

package io.fabric8.openshift.client.dsl.internal.core;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigration;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigrationBuilder;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigrationList;

import java.util.Map;
import java.util.TreeMap;


public class StorageVersionMigrationOperationsImpl extends OpenShiftOperation<StorageVersionMigration, StorageVersionMigrationList, Resource<StorageVersionMigration>> {

  public StorageVersionMigrationOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public StorageVersionMigrationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("migration.k8s.io")
    .withApiGroupVersion("v1alpha1")
    .withPlural("storageversionmigrations"));
    this.type = StorageVersionMigration.class;
    this.listType = StorageVersionMigrationList.class;
  }

  public StorageVersionMigrationOperationsImpl newInstance(OperationContext context) {
    return new StorageVersionMigrationOperationsImpl(context);
  }

  @Override
  public StorageVersionMigration edit(Visitor... visitors) {
    return patch(new StorageVersionMigrationBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
