
                                                    
      

package io.fabric8.openshift.client.dsl.internal.machine;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheck;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.MachineHealthCheckList;

import java.util.Map;
import java.util.TreeMap;


public class MachineHealthCheckOperationsImpl extends OpenShiftOperation<MachineHealthCheck, MachineHealthCheckList, Resource<MachineHealthCheck>> {

  public MachineHealthCheckOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public MachineHealthCheckOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("machine.openshift.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("machinehealthchecks"));
    this.type = MachineHealthCheck.class;
    this.listType = MachineHealthCheckList.class;
  }

  public MachineHealthCheckOperationsImpl newInstance(OperationContext context) {
    return new MachineHealthCheckOperationsImpl(context);
  }

  @Override
  public MachineHealthCheck edit(Visitor... visitors) {
    return patch(new MachineHealthCheckBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
