
                                                    
  

package io.fabric8.openshift.client.dsl.internal.machineconfiguration;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfig;
import io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigBuilder;
import io.fabric8.openshift.api.model.machineconfig.v1.ControllerConfigList;

import java.util.Map;
import java.util.TreeMap;


public class ControllerConfigOperationsImpl extends OpenShiftOperation<ControllerConfig, ControllerConfigList, Resource<ControllerConfig>> {

  public ControllerConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ControllerConfigOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("machineconfiguration.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("controllerconfigs"));
    this.type = ControllerConfig.class;
    this.listType = ControllerConfigList.class;
  }

  public ControllerConfigOperationsImpl newInstance(OperationContext context) {
    return new ControllerConfigOperationsImpl(context);
  }

  @Override
  public ControllerConfig edit(Visitor... visitors) {
    return patch(new ControllerConfigBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
