
                                                    
  

package io.fabric8.openshift.client.dsl.internal.network;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.HostSubnet;
import io.fabric8.openshift.api.model.HostSubnetBuilder;
import io.fabric8.openshift.api.model.HostSubnetList;

import java.util.Map;
import java.util.TreeMap;


public class HostSubnetOperationsImpl extends OpenShiftOperation<HostSubnet, HostSubnetList, Resource<HostSubnet>> {

  public HostSubnetOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public HostSubnetOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("network.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("hostsubnets"));
    this.type = HostSubnet.class;
    this.listType = HostSubnetList.class;
  }

  public HostSubnetOperationsImpl newInstance(OperationContext context) {
    return new HostSubnetOperationsImpl(context);
  }

  @Override
  public HostSubnet edit(Visitor... visitors) {
    return patch(new HostSubnetBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
