
                                                    
  

package io.fabric8.openshift.client.dsl.internal.oauth;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.UserOAuthAccessToken;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenBuilder;
import io.fabric8.openshift.api.model.UserOAuthAccessTokenList;

import java.util.Map;
import java.util.TreeMap;


public class UserOAuthAccessTokenOperationsImpl extends OpenShiftOperation<UserOAuthAccessToken, UserOAuthAccessTokenList, Resource<UserOAuthAccessToken>> {

  public UserOAuthAccessTokenOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public UserOAuthAccessTokenOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("oauth.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("useroauthaccesstokens"));
    this.type = UserOAuthAccessToken.class;
    this.listType = UserOAuthAccessTokenList.class;
  }

  public UserOAuthAccessTokenOperationsImpl newInstance(OperationContext context) {
    return new UserOAuthAccessTokenOperationsImpl(context);
  }

  @Override
  public UserOAuthAccessToken edit(Visitor... visitors) {
    return patch(new UserOAuthAccessTokenBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
