
                                                    
  

package io.fabric8.openshift.client.dsl.internal.operator;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.Config;
import io.fabric8.openshift.api.model.operator.v1.ConfigBuilder;
import io.fabric8.openshift.api.model.operator.v1.ConfigList;

import java.util.Map;
import java.util.TreeMap;


public class ConfigOperationsImpl extends OpenShiftOperation<Config, ConfigList, Resource<Config>> {

  public ConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConfigOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("configs"));
    this.type = Config.class;
    this.listType = ConfigList.class;
  }

  public ConfigOperationsImpl newInstance(OperationContext context) {
    return new ConfigOperationsImpl(context);
  }

  @Override
  public Config edit(Visitor... visitors) {
    return patch(new ConfigBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
