
                                                    
  

package io.fabric8.openshift.client.dsl.internal.operator;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManager;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerBuilder;
import io.fabric8.openshift.api.model.operator.v1.ServiceCatalogControllerManagerList;

import java.util.Map;
import java.util.TreeMap;


public class ServiceCatalogControllerManagerOperationsImpl extends OpenShiftOperation<ServiceCatalogControllerManager, ServiceCatalogControllerManagerList, Resource<ServiceCatalogControllerManager>> {

  public ServiceCatalogControllerManagerOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ServiceCatalogControllerManagerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operator.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("servicecatalogcontrollermanagers"));
    this.type = ServiceCatalogControllerManager.class;
    this.listType = ServiceCatalogControllerManagerList.class;
  }

  public ServiceCatalogControllerManagerOperationsImpl newInstance(OperationContext context) {
    return new ServiceCatalogControllerManagerOperationsImpl(context);
  }

  @Override
  public ServiceCatalogControllerManager edit(Visitor... visitors) {
    return patch(new ServiceCatalogControllerManagerBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
