
                                                    
      

package io.fabric8.openshift.client.dsl.internal.operators.coreos;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operatorhub.v1.OperatorCondition;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionList;

import java.util.Map;
import java.util.TreeMap;


public class OperatorConditionOperationsImpl extends OpenShiftOperation<OperatorCondition, OperatorConditionList, Resource<OperatorCondition>> {

  public OperatorConditionOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public OperatorConditionOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("operators.coreos.com")
    .withApiGroupVersion("v1")
    .withPlural("operatorconditions"));
    this.type = OperatorCondition.class;
    this.listType = OperatorConditionList.class;
  }

  public OperatorConditionOperationsImpl newInstance(OperationContext context) {
    return new OperatorConditionOperationsImpl(context);
  }

  @Override
  public OperatorCondition edit(Visitor... visitors) {
    return patch(new OperatorConditionBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
