
                                                    
      

package io.fabric8.openshift.client.dsl.internal.tuned;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.tuned.v1.Profile;
import io.fabric8.openshift.api.model.tuned.v1.ProfileBuilder;
import io.fabric8.openshift.api.model.tuned.v1.ProfileList;

import java.util.Map;
import java.util.TreeMap;


public class ProfileOperationsImpl extends OpenShiftOperation<Profile, ProfileList, Resource<Profile>> {

  public ProfileOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ProfileOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("tuned.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("profiles"));
    this.type = Profile.class;
    this.listType = ProfileList.class;
  }

  public ProfileOperationsImpl newInstance(OperationContext context) {
    return new ProfileOperationsImpl(context);
  }

  @Override
  public Profile edit(Visitor... visitors) {
    return patch(new ProfileBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
