
                                                    
      

package io.fabric8.openshift.client.dsl.internal.tuned;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.openshift.client.dsl.internal.OpenShiftOperation;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.tuned.v1.Tuned;
import io.fabric8.openshift.api.model.tuned.v1.TunedBuilder;
import io.fabric8.openshift.api.model.tuned.v1.TunedList;

import java.util.Map;
import java.util.TreeMap;


public class TunedOperationsImpl extends OpenShiftOperation<Tuned, TunedList, Resource<Tuned>> {

  public TunedOperationsImpl(OkHttpClient client, OpenShiftConfig config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public TunedOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("tuned.openshift.io")
    .withApiGroupVersion("v1")
    .withPlural("tuneds"));
    this.type = Tuned.class;
    this.listType = TunedList.class;
  }

  public TunedOperationsImpl newInstance(OperationContext context) {
    return new TunedOperationsImpl(context);
  }

  @Override
  public Tuned edit(Visitor... visitors) {
    return patch(new TunedBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
