
                                                    

package io.fabric8.openshift.client.handlers.apps;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.apps.DeploymentConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;

public class DeploymentConfigHandler implements ResourceHandler<DeploymentConfig, DeploymentConfigBuilder> {

  @Override
  public String getKind() {
    return DeploymentConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "apps.openshift.io/v1";
    }

  @Override
  public DeploymentConfigBuilder edit(DeploymentConfig item) {
    return new DeploymentConfigBuilder(item);
  }

  @Override
  public Resource<DeploymentConfig> resource(OkHttpClient client, Config config, String namespace, DeploymentConfig item) {
    return new DeploymentConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
