
                                                    

package io.fabric8.openshift.client.handlers.authorization;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.authorization.ClusterRoleBindingOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingBuilder;

public class ClusterRoleBindingHandler implements ResourceHandler<ClusterRoleBinding, ClusterRoleBindingBuilder> {

  @Override
  public String getKind() {
    return ClusterRoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authorization.openshift.io/v1";
    }

  @Override
  public ClusterRoleBindingBuilder edit(ClusterRoleBinding item) {
    return new ClusterRoleBindingBuilder(item);
  }

  @Override
  public Resource<ClusterRoleBinding> resource(OkHttpClient client, Config config, String namespace, ClusterRoleBinding item) {
    return new ClusterRoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
