
                                                    

package io.fabric8.openshift.client.handlers.authorization;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleBindingOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingBuilder;

public class RoleBindingHandler implements ResourceHandler<RoleBinding, RoleBindingBuilder> {

  @Override
  public String getKind() {
    return RoleBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authorization.openshift.io/v1";
    }

  @Override
  public RoleBindingBuilder edit(RoleBinding item) {
    return new RoleBindingBuilder(item);
  }

  @Override
  public Resource<RoleBinding> resource(OkHttpClient client, Config config, String namespace, RoleBinding item) {
    return new RoleBindingOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
