
                                                    

package io.fabric8.openshift.client.handlers.authorization;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.authorization.RoleOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBuilder;

public class RoleHandler implements ResourceHandler<Role, RoleBuilder> {

  @Override
  public String getKind() {
    return Role.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "authorization.openshift.io/v1";
    }

  @Override
  public RoleBuilder edit(Role item) {
    return new RoleBuilder(item);
  }

  @Override
  public Resource<Role> resource(OkHttpClient client, Config config, String namespace, Role item) {
    return new RoleOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
