
                                                    

package io.fabric8.openshift.client.handlers.build;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.build.BuildConfigOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.BuildConfig;
import io.fabric8.openshift.api.model.BuildConfigBuilder;

public class BuildConfigHandler implements ResourceHandler<BuildConfig, BuildConfigBuilder> {

  @Override
  public String getKind() {
    return BuildConfig.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "build.openshift.io/v1";
    }

  @Override
  public BuildConfigBuilder edit(BuildConfig item) {
    return new BuildConfigBuilder(item);
  }

  @Override
  public Resource<BuildConfig> resource(OkHttpClient client, Config config, String namespace, BuildConfig item) {
    return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
