
                                                    

package io.fabric8.openshift.client.handlers.build;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.build.BuildOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Build;
import io.fabric8.openshift.api.model.BuildBuilder;

public class BuildHandler implements ResourceHandler<Build, BuildBuilder> {

  @Override
  public String getKind() {
    return Build.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "build.openshift.io/v1";
    }

  @Override
  public BuildBuilder edit(Build item) {
    return new BuildBuilder(item);
  }

  @Override
  public Resource<Build> resource(OkHttpClient client, Config config, String namespace, Build item) {
    return new BuildOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
