
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.ClusterOperatorOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ClusterOperator;
import io.fabric8.openshift.api.model.ClusterOperatorBuilder;

public class ClusterOperatorHandler implements ResourceHandler<ClusterOperator, ClusterOperatorBuilder> {

  @Override
  public String getKind() {
    return ClusterOperator.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public ClusterOperatorBuilder edit(ClusterOperator item) {
    return new ClusterOperatorBuilder(item);
  }

  @Override
  public Resource<ClusterOperator> resource(OkHttpClient client, Config config, String namespace, ClusterOperator item) {
    return new ClusterOperatorOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
