
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.InfrastructureOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Infrastructure;
import io.fabric8.openshift.api.model.InfrastructureBuilder;

public class InfrastructureHandler implements ResourceHandler<Infrastructure, InfrastructureBuilder> {

  @Override
  public String getKind() {
    return Infrastructure.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public InfrastructureBuilder edit(Infrastructure item) {
    return new InfrastructureBuilder(item);
  }

  @Override
  public Resource<Infrastructure> resource(OkHttpClient client, Config config, String namespace, Infrastructure item) {
    return new InfrastructureOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
