
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.IngressOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Ingress;
import io.fabric8.openshift.api.model.IngressBuilder;

public class IngressHandler implements ResourceHandler<Ingress, IngressBuilder> {

  @Override
  public String getKind() {
    return Ingress.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public IngressBuilder edit(Ingress item) {
    return new IngressBuilder(item);
  }

  @Override
  public Resource<Ingress> resource(OkHttpClient client, Config config, String namespace, Ingress item) {
    return new IngressOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
