
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.OAuthOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OAuth;
import io.fabric8.openshift.api.model.OAuthBuilder;

public class OAuthHandler implements ResourceHandler<OAuth, OAuthBuilder> {

  @Override
  public String getKind() {
    return OAuth.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public OAuthBuilder edit(OAuth item) {
    return new OAuthBuilder(item);
  }

  @Override
  public Resource<OAuth> resource(OkHttpClient client, Config config, String namespace, OAuth item) {
    return new OAuthOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
