
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.OperatorHubOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.OperatorHub;
import io.fabric8.openshift.api.model.OperatorHubBuilder;

public class OperatorHubHandler implements ResourceHandler<OperatorHub, OperatorHubBuilder> {

  @Override
  public String getKind() {
    return OperatorHub.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public OperatorHubBuilder edit(OperatorHub item) {
    return new OperatorHubBuilder(item);
  }

  @Override
  public Resource<OperatorHub> resource(OkHttpClient client, Config config, String namespace, OperatorHub item) {
    return new OperatorHubOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
