
                                                    

package io.fabric8.openshift.client.handlers.config;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.config.ProxyOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyBuilder;

public class ProxyHandler implements ResourceHandler<Proxy, ProxyBuilder> {

  @Override
  public String getKind() {
    return Proxy.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "config.openshift.io/v1";
    }

  @Override
  public ProxyBuilder edit(Proxy item) {
    return new ProxyBuilder(item);
  }

  @Override
  public Resource<Proxy> resource(OkHttpClient client, Config config, String namespace, Proxy item) {
    return new ProxyOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
