
                                                    

package io.fabric8.openshift.client.handlers.console;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleCLIDownloadOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownload;
import io.fabric8.openshift.api.model.console.v1.ConsoleCLIDownloadBuilder;

public class ConsoleCLIDownloadHandler implements ResourceHandler<ConsoleCLIDownload, ConsoleCLIDownloadBuilder> {

  @Override
  public String getKind() {
    return ConsoleCLIDownload.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleCLIDownloadBuilder edit(ConsoleCLIDownload item) {
    return new ConsoleCLIDownloadBuilder(item);
  }

  @Override
  public Resource<ConsoleCLIDownload> resource(OkHttpClient client, Config config, String namespace, ConsoleCLIDownload item) {
    return new ConsoleCLIDownloadOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
