
                                                    

package io.fabric8.openshift.client.handlers.console;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleExternalLogLinkOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleExternalLogLinkBuilder;

public class ConsoleExternalLogLinkHandler implements ResourceHandler<ConsoleExternalLogLink, ConsoleExternalLogLinkBuilder> {

  @Override
  public String getKind() {
    return ConsoleExternalLogLink.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleExternalLogLinkBuilder edit(ConsoleExternalLogLink item) {
    return new ConsoleExternalLogLinkBuilder(item);
  }

  @Override
  public Resource<ConsoleExternalLogLink> resource(OkHttpClient client, Config config, String namespace, ConsoleExternalLogLink item) {
    return new ConsoleExternalLogLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
