
                                                    

package io.fabric8.openshift.client.handlers.console;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleLinkOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleLink;
import io.fabric8.openshift.api.model.console.v1.ConsoleLinkBuilder;

public class ConsoleLinkHandler implements ResourceHandler<ConsoleLink, ConsoleLinkBuilder> {

  @Override
  public String getKind() {
    return ConsoleLink.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleLinkBuilder edit(ConsoleLink item) {
    return new ConsoleLinkBuilder(item);
  }

  @Override
  public Resource<ConsoleLink> resource(OkHttpClient client, Config config, String namespace, ConsoleLink item) {
    return new ConsoleLinkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
