
                                                    

package io.fabric8.openshift.client.handlers.console;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.console.ConsoleNotificationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.console.v1.ConsoleNotification;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationBuilder;

public class ConsoleNotificationHandler implements ResourceHandler<ConsoleNotification, ConsoleNotificationBuilder> {

  @Override
  public String getKind() {
    return ConsoleNotification.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "console.openshift.io/v1";
    }

  @Override
  public ConsoleNotificationBuilder edit(ConsoleNotification item) {
    return new ConsoleNotificationBuilder(item);
  }

  @Override
  public Resource<ConsoleNotification> resource(OkHttpClient client, Config config, String namespace, ConsoleNotification item) {
    return new ConsoleNotificationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
