
                                                    

package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.core.BareMetalHostOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHost;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.BareMetalHostBuilder;

public class BareMetalHostHandler implements ResourceHandler<BareMetalHost, BareMetalHostBuilder> {

  @Override
  public String getKind() {
    return BareMetalHost.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "metal3.io/v1alpha1";
    }

  @Override
  public BareMetalHostBuilder edit(BareMetalHost item) {
    return new BareMetalHostBuilder(item);
  }

  @Override
  public Resource<BareMetalHost> resource(OkHttpClient client, Config config, String namespace, BareMetalHost item) {
    return new BareMetalHostOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
