
                                                    

package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.core.OverlappingRangeIPReservationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.whereabouts.v1alpha1.OverlappingRangeIPReservation;
import io.fabric8.openshift.api.model.whereabouts.v1alpha1.OverlappingRangeIPReservationBuilder;

public class OverlappingRangeIPReservationHandler implements ResourceHandler<OverlappingRangeIPReservation, OverlappingRangeIPReservationBuilder> {

  @Override
  public String getKind() {
    return OverlappingRangeIPReservation.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "whereabouts.cni.cncf.io/v1alpha1";
    }

  @Override
  public OverlappingRangeIPReservationBuilder edit(OverlappingRangeIPReservation item) {
    return new OverlappingRangeIPReservationBuilder(item);
  }

  @Override
  public Resource<OverlappingRangeIPReservation> resource(OkHttpClient client, Config config, String namespace, OverlappingRangeIPReservation item) {
    return new OverlappingRangeIPReservationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
