
                                                    

package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.core.StorageVersionMigrationOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigration;
import io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageVersionMigrationBuilder;

public class StorageVersionMigrationHandler implements ResourceHandler<StorageVersionMigration, StorageVersionMigrationBuilder> {

  @Override
  public String getKind() {
    return StorageVersionMigration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "migration.k8s.io/v1alpha1";
    }

  @Override
  public StorageVersionMigrationBuilder edit(StorageVersionMigration item) {
    return new StorageVersionMigrationBuilder(item);
  }

  @Override
  public Resource<StorageVersionMigration> resource(OkHttpClient client, Config config, String namespace, StorageVersionMigration item) {
    return new StorageVersionMigrationOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
