
                                            

package io.fabric8.openshift.client.handlers.core;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.core.TemplateOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateBuilder;

public class TemplateHandler implements ResourceHandler<Template, TemplateBuilder> {

  @Override
  public String getKind() {
    return Template.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "v1";
    }

  @Override
  public TemplateBuilder edit(Template item) {
    return new TemplateBuilder(item);
  }

  @Override
  public Resource<Template> resource(OkHttpClient client, Config config, String namespace, Template item) {
    return new TemplateOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
