
                                                    

package io.fabric8.openshift.client.handlers.helm;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.helm.HelmChartRepositoryOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.HelmChartRepository;
import io.fabric8.openshift.api.model.HelmChartRepositoryBuilder;

public class HelmChartRepositoryHandler implements ResourceHandler<HelmChartRepository, HelmChartRepositoryBuilder> {

  @Override
  public String getKind() {
    return HelmChartRepository.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "helm.openshift.io/v1beta1";
    }

  @Override
  public HelmChartRepositoryBuilder edit(HelmChartRepository item) {
    return new HelmChartRepositoryBuilder(item);
  }

  @Override
  public Resource<HelmChartRepository> resource(OkHttpClient client, Config config, String namespace, HelmChartRepository item) {
    return new HelmChartRepositoryOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
