
                                                    

package io.fabric8.openshift.client.handlers.image;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.image.ImageOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;

public class ImageHandler implements ResourceHandler<Image, ImageBuilder> {

  @Override
  public String getKind() {
    return Image.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "image.openshift.io/v1";
    }

  @Override
  public ImageBuilder edit(Image item) {
    return new ImageBuilder(item);
  }

  @Override
  public Resource<Image> resource(OkHttpClient client, Config config, String namespace, Image item) {
    return new ImageOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
