
                                                    

package io.fabric8.openshift.client.handlers.image;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.image.ImageStreamOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ImageStream;
import io.fabric8.openshift.api.model.ImageStreamBuilder;

public class ImageStreamHandler implements ResourceHandler<ImageStream, ImageStreamBuilder> {

  @Override
  public String getKind() {
    return ImageStream.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "image.openshift.io/v1";
    }

  @Override
  public ImageStreamBuilder edit(ImageStream item) {
    return new ImageStreamBuilder(item);
  }

  @Override
  public Resource<ImageStream> resource(OkHttpClient client, Config config, String namespace, ImageStream item) {
    return new ImageStreamOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
