
                                                    

package io.fabric8.openshift.client.handlers.image;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.image.ImageStreamTagOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagBuilder;

public class ImageStreamTagHandler implements ResourceHandler<ImageStreamTag, ImageStreamTagBuilder> {

  @Override
  public String getKind() {
    return ImageStreamTag.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "image.openshift.io/v1";
    }

  @Override
  public ImageStreamTagBuilder edit(ImageStreamTag item) {
    return new ImageStreamTagBuilder(item);
  }

  @Override
  public Resource<ImageStreamTag> resource(OkHttpClient client, Config config, String namespace, ImageStreamTag item) {
    return new ImageStreamTagOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
