
                                                    

package io.fabric8.openshift.client.handlers.imageregistry.operator;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.openshift.client.OpenShiftConfig;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.openshift.client.dsl.internal.imageregistry.operator.ImagePrunerOperationsImpl;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;

import io.fabric8.openshift.client.OpenShiftConfig;

import okhttp3.OkHttpClient;

import io.fabric8.openshift.api.model.operator.v1.ImagePruner;
import io.fabric8.openshift.api.model.operator.v1.ImagePrunerBuilder;

public class ImagePrunerHandler implements ResourceHandler<ImagePruner, ImagePrunerBuilder> {

  @Override
  public String getKind() {
    return ImagePruner.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
      return "imageregistry.operator.openshift.io/v1";
    }

  @Override
  public ImagePrunerBuilder edit(ImagePruner item) {
    return new ImagePrunerBuilder(item);
  }

  @Override
  public Resource<ImagePruner> resource(OkHttpClient client, Config config, String namespace, ImagePruner item) {
    return new ImagePrunerOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
